@echo off
setlocal EnableExtensions EnableDelayedExpansion
title Kane and Lynch 2 - CZ Patch (LOC -> ZIP)

echo ==============================================
echo   Kane and Lynch 2 - Community CZ Patch
echo   Zapise prelozene .LOC do hernich ZIP archivu
echo   Pred tim vytvori .bak zalohy
echo ==============================================
echo.

rem --- dotaz na slozku hry ---
set "DEFAULT_DIR=C:\Program Files (x86)\Steam\steamapps\common\Kane and Lynch 2 Dog Days"
echo Zadej cestu ke slozce hry (Enter pro [%DEFAULT_DIR%]):
set "GAME_DIR="
set /p GAME_DIR=PATH:
if "%GAME_DIR%"=="" set "GAME_DIR=%DEFAULT_DIR%"

if not exist "%GAME_DIR%" (
  echo Chyba: slozka neexistuje: "%GAME_DIR%"
  pause
  exit /b 1
)

echo.
echo Pouzita slozka hry: "%GAME_DIR%"
echo.

rem --- cesty na preklady ---
set "SELF_DIR=%~dp0"
set "REPL_MAIN=%SELF_DIR%replacements\L_Main"
set "REPL_LOADER=%SELF_DIR%replacements\Loader_Sequence"
set "REPL_ROOT=%SELF_DIR%replacements\RootScenes"

if not exist "%REPL_MAIN%"   echo Varovani: chybi "%REPL_MAIN%"
if not exist "%REPL_LOADER%" echo Varovani: chybi "%REPL_LOADER%"
if not exist "%REPL_ROOT%"   echo Varovani: chybi "%REPL_ROOT%"

rem --- L00 ---
call :PatchOne "%GAME_DIR%\Scenes\Locations\L00\L00_Main.zip" "%REPL_MAIN%\L00_MainEnglish.LOC" "Scenes\Locations\L00\L00_MainEnglish.LOC"

rem --- L01..L11 ---
for /l %%I in (1,1,11) do (
  set "NN=0%%I"
  set "LNUM=!NN:~-2!"
  call :PatchOne "%GAME_DIR%\Scenes\Locations\L!LNUM!\L!LNUM!_Main.zip"    "%REPL_MAIN%\L!LNUM!_MainEnglish.LOC"      "Scenes\Locations\L!LNUM!\L!LNUM!_MainEnglish.LOC"
  call :PatchOne "%GAME_DIR%\Scenes\Locations\L!LNUM!\Loader_Sequence.zip" "%REPL_LOADER%\Loader_SequenceEnglish.LOC" "Scenes\Locations\L!LNUM!\Loader_SequenceEnglish.LOC"
)

rem --- root Scenes ---
call :PatchOne "%GAME_DIR%\Scenes\kaneandlynch.zip" "%REPL_ROOT%\kaneandlynchEnglish.LOC" "Scenes\kaneandlynchEnglish.LOC"

echo.
echo ==============================================
echo HOTOVO.
echo Zaloha vytvorena jako *.bak vedle kazdeho upraveneho ZIPu.
echo Navrat zpet: smaz aktualni ZIP a .bak prejmenuj na puvodni.
echo ==============================================
echo.
pause
exit /b 0

:PatchOne
rem %1 = cesta k ZIP, %2 = zdrojovy LOC, %3 = vnitrni cesta v ZIPu
set "ZIP=%~1"
set "SRC=%~2"
set "ENTRY=%~3"

echo.
echo --- Patche: "%ENTRY%"

if not exist "%ZIP%" (
  echo   [SKIP] Nenalezen archiv: "%ZIP%"
  exit /b 0
)
if not exist "%SRC%" (
  echo   [SKIP] Chybi zdroj: "%SRC%"
  exit /b 0
)

rem zaloha jednou
if not exist "%ZIP%.bak" copy /y "%ZIP%" "%ZIP%.bak" >nul

rem volani PowerShell helperu
powershell -NoProfile -ExecutionPolicy Bypass -File "%SELF_DIR%patch_zip.ps1" -Zip "%ZIP%" -Src "%SRC%" -Entry "%ENTRY%"
if errorlevel 1 (
  echo   [FAIL] Zapis do ZIP selhal.
) else (
  echo   [OK] Zapsano do: "%~nx1"
)
exit /b 0
